/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.justverticalslabs.model;

import com.mojang.blaze3d.vertex.PoseStack;
import crystalspider.justverticalslabs.JustVerticalSlabsLoader;
import crystalspider.justverticalslabs.blocks.VerticalSlabBlock;
import crystalspider.justverticalslabs.model.VerticalSlabModelKey;
import crystalspider.justverticalslabs.model.item.VerticalSlabItemOverrides;
import crystalspider.justverticalslabs.model.perpective.VerticalSlabPerspectiveTransformer;
import crystalspider.justverticalslabs.model.utils.BakedQuadUtils;
import crystalspider.justverticalslabs.model.utils.ModelUtils;
import crystalspider.justverticalslabs.model.utils.VertexUtils;
import crystalspider.justverticalslabs.utils.VerticalSlabUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class VerticalSlabBakedModel
implements IDynamicBakedModel {
    private final BakedModel jsonBakedModel;
    private final ItemOverrides overrides;
    private final HashMap<VerticalSlabModelKey, List<BakedQuad>> bakedQuadsCache = new HashMap();

    public VerticalSlabBakedModel(BakedModel jsonBakedModel) {
        this.jsonBakedModel = jsonBakedModel;
        this.overrides = new VerticalSlabItemOverrides();
        JustVerticalSlabsLoader.LOGGER.trace("Baked VerticalSlabModel.");
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7541_() {
        return true;
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public BakedModel applyTransform(ItemTransforms.TransformType transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        ItemTransform transform = VerticalSlabPerspectiveTransformer.getTransform(transformType);
        if (transform != ItemTransform.f_111754_) {
            transform.m_111763_(applyLeftHandTransform, poseStack);
        }
        return this;
    }

    public TextureAtlasSprite m_6160_() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(MissingTextureAtlasSprite.m_118071_());
    }

    public TextureAtlasSprite getParticleIcon(ModelData extraData) {
        BlockState referredSlabState = (BlockState)extraData.get(VerticalSlabUtils.REFERRED_SLAB_STATE);
        if (referredSlabState != null) {
            return ModelUtils.getReferredBakedModel(referredSlabState).getParticleIcon(ModelUtils.getReferredModelData(referredSlabState, extraData));
        }
        return this.m_6160_();
    }

    @Nonnull
    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        BlockState referredSlabState = (BlockState)extraData.get(VerticalSlabUtils.REFERRED_SLAB_STATE);
        if (referredSlabState != null) {
            boolean isDouble = state != null && (Boolean)state.m_61143_((Property)VerticalSlabBlock.DOUBLE) != false;
            VerticalSlabModelKey verticalSlabModelKey = new VerticalSlabModelKey(side, referredSlabState, isDouble);
            if (!this.bakedQuadsCache.containsKey(verticalSlabModelKey)) {
                if (isDouble) {
                    this.bakedQuadsCache.put(verticalSlabModelKey, BakedQuadUtils.getReferredBakedQuads((BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE), side, rand, extraData, renderType));
                } else {
                    BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
                    boolean referringBlock = referredBlockState != null && VerticalSlabUtils.isTranslucent(referredSlabState);
                    ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
                    for (BakedQuad jsonBakedQuad : this.jsonBakedModel.getQuads(state, side, rand, extraData, renderType)) {
                        Direction orientation = jsonBakedQuad.m_111306_();
                        for (BakedQuad referredBakedQuad : BakedQuadUtils.getReferredBakedQuads(referringBlock ? referredBlockState : referredSlabState, orientation, rand, extraData, renderType)) {
                            if (VertexUtils.isInternalFace(referredBakedQuad.m_111303_(), referringBlock)) continue;
                            bakedQuads.add(BakedQuadUtils.getNewBakedQuad(jsonBakedQuad, referredBakedQuad, orientation));
                        }
                    }
                    this.bakedQuadsCache.put(verticalSlabModelKey, bakedQuads);
                }
            }
            return this.bakedQuadsCache.get(verticalSlabModelKey);
        }
        return this.jsonBakedModel.getQuads(state, side, rand, extraData, renderType);
    }
}

